-- Localization strings English

struct nvpxText
(
  noticeRebootWhenOldMenu = "There are old menus or macros in your system. It is better to restart 3ds Max. If not, it may show strange wrong menus or behavior strangely.",

  bakeProgressCaptionClothing = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX baking clothing..." else
	"PhysX baking clothing..."),
  bakeProgressCaptionRegular = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX baking..." else
	"PhysX baking..."),
  bakeControllerPosName = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Baked Position" else
	"PhysX Baked Position" ),
  bakeControllerRotName = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Baked Rotation" else
	"PhysX Baked Rotation"),

	fileVersionIsEarlier = "Earlier than 2.6.2",
	fileVersionDlgInfo = "The MassFX authored in this file was created with:\n\t",
	fileVersionDlgTitle = "The Plugin Build Version of the Max File",
	fileVersionCheckDlgWarning = "The MassFX authored in this file was created with a newer version of the plugins. Forward compatibility is not supported, so things might not behave properly.",
	warningDlgTitle = "Warning",
	errorDlgTitle = "Error",

  compatibilitySolveConvertOld = "The 3ds Max file is made of old PhysX Plugin.\nDo you want to convert to current version?",
  compatibilitySolveWarning = (if PHYSX_AUTODESK_VER!=undefined then
    "The Max has been converted to current MassFX version.\nPlease manually rename this file if you do not want to overwrite the old one." else
    "The Max has been converted to current PhysX version.\nPlease manually rename this file if you do not want to overwrite the old one."),

  constraintQueryMustBeRB = "Objects connected by a constraint must be Rigid Bodies.\n",
  constraintQueryApplyRBMTo1 = (if PHYSX_AUTODESK_VER!=undefined then
    "Apply a MassFX Rigid Body modifier to %?" else
	"Apply a PhysX Rigid Body modifier to %?"),
  constraintQueryApplyRBMTo2 = (if PHYSX_AUTODESK_VER!=undefined then
    "Apply a MassFX Rigid Body modifier to % and %?" else
	"Apply a PhysX Rigid Body modifier to % and %?"),
  constraintMsgStaticRBNotPartOfConstraint = "Static rigid bodies may not be used as part of a constraint.",
  constraintMsgConstraintWith2KRB = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX does not support making a constraint with two Kinematic Rigid Bodies." else
	"PhysX does not support making a constraint with two Kinematic Rigid Bodies."),
  constraintMsgNoOnSingleKRB = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX does not support constraints to a single kinematic rigid body." else
	"PhysX does not support constraints to a single kinematic rigid body."),

  displayPanelVisualizer = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Visualizer" else
    "PhysX Visualizer"),
  displayPanelVisualizerOptions = "Options",
  displayPanelVisualizerEnable = "Enable Visualizer",
  displayPanelVisualizerScale = "Scale",
  displayPanelVisualizerScaleTT = "Scale Factor for all Visualizer Helpers",
  displayPanelObjProp = "Object Properties",
  displayPanelJointProp = "Joint Properties",
  displayPanelContactMarkers = "Contact Markers",
  displayPanelCollMarkers = "Collision Markers",
  displayPanelBodyAxis = "Local Axis",
  displayPanelBodyLinearVel = "Object Linear Velocity",
  displayPanelBodyAngularVel = "Object Angular Velocity",
  displayPanelJointLocalAxis = "Local Axis",
  displayPanelJointWorldAxis = "World Axis",
  displayPanelJointLimits = "Joint Limits",
  displayPanelContactPoints = "Contact Points",
  displayPanelContactNormal = "Contact Normals",
  displayPanelContactForce = "Contact Force",
  displayPanelCollisionShapes = "Collision Meshes",
  displayPanelCollisionCompounds = "Collision Groups",
  displayPanelCollisionSpheres = "Collision Spheres",
  -- the following 2 strings are used to build a undo command name 
  -- displayPanelVisualizerUndoStart + PARAMNAME + displayPanelVisualizerUndoEnd
  displayPanelVisualizerUndoStart = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Visualizer " else
    "PhysX Visualizer "),
  displayPanelVisualizerUndoEnd = " edit",

  globalsCreationToolPrompt = "Size Constraint",
  globalsRemoveOldRagdoll = (if PHYSX_AUTODESK_VER!=undefined then
    "Delete the MassFX Rigid Bodies associated with this Ragdoll?" else
	"Delete the PhysX Rigid Bodies associated with this Ragdoll?"),
  globalsImportTemplateCaption = "Select .ctw file to import... ",
  globalsExportTemplateCaption = "Choose where to export .ctw file to...",

  guiMenuNoGroupCloth = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX does not support making Group object as Cloth. They are unchanged." else
    "PhysX does not support making Group object as Cloth. They are unchanged." ),
  guiMenuNoGroupSB = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX does not support making Group object as Softbody. They are unchanged." else
    "PhysX does not support making Group object as Softbody. They are unchanged."),
  guiMenuNoGroupFF = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX does not support making Group object as Forcefield. They are unchanged." else
    "PhysX does not support making Group object as Forcefield. They are unchanged."),
  guiMenuNoHelper = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX does not support Helpers. Helpers are unchanged." else
    "PhysX does not support Helpers. Helpers are unchanged."),
  guiMenuExport = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Export" else
    "PhysX Export"),
  guiMenuExporting = (if PHYSX_AUTODESK_VER!=undefined then
    "Exporting MassFX Scene" else
    "Exporting PhysX Scene"),
  guiMenuExportValidate = "Validate scene before export",
  guiMenuExportNewFile = "Export to new file",
  guiMenuExportToLast = "Export to last file/type",

  meshExportCaption = "Save nVIDIA PhysX mesh as:",

  panelMultiSelectionTitle = "Selection",
  panelMultiSelectionEmpty_Part1 = "No editable objects selected.", -- LOC: These four strings form one message
  panelMultiSelectionEmpty_Part2 = "Please select Rigid Body objects",
  panelMultiSelectionEmpty_Part3 = "or Constraints to continue editing.",
  panelMultiSelectionEmpty_Part4 = "",

  panelMultiSelectionMixed_Part1 = "Mixture of objects selected.", -- LOC: These four strings form one message
  panelMultiSelectionMixed_Part2 = "Selection should contain only",
  panelMultiSelectionMixed_Part3 = "Rigid Body objects, or Constraints",
  panelMultiSelectionMixed_Part4 = "to continue editing.",

  panelMultiPromptName = "Prompt For Name",
  panelMultiOk = "OK",
  panelMultiCancel = "Cancel",
  panelMultiRB = "Rigid Body Properties",
  panelMultiRBType = "Rigid Body Type",
  panelMultiRBTypeDynamic = "Dynamic",
  panelMultiRBTypeKinematic = "Kinematic",
  panelMultiRBTypeStatic = "Static",
  panelMultiRBUntilFrame = "Until Frame",
  panelMultiRBBake = "Bake",
  panelMultiRBUnbake = "Unbake",
  panelMultiRBBakeUnbake = "(Bake or Unbake)",
  panelMultiRBHVC = "Use High Velocity Collisions",
  panelMultiRBSleep = "Start in Sleep Mode",
  panelMultiRBCollide = "Collide with Rigid Bodies",
  panelMultiMat = "Physical Material",
  panelMultiMatPreset = "Preset",
  panelMultiMatPresetCreate = "Create Preset",
  panelMultiMatPresetDelete = "Delete Preset",
  panelMultiMatPresetNone = "(none)",
  panelMultiMatPromptName = "Physical Material Name",
  panelMultiMatUnnamed = "Unnamed Material",
  panelMultiMatProp = "Physical Material Properties",
  panelMultiMatPropDensity = "Density",
  panelMultiMatPropMass = "Mass",
  panelMultiMatPropStaticFriction = "Static Friction",
  panelMultiMatPropDynFriction = "Dynamic Friction",
  panelMultiMatPropBounce = "Bounciness",
  panelMultiPhyMesh = "Physical Mesh",
  panelMultiPhyMeshType = "Mesh Type",
  panelMultiPhyMeshTSphere = "Sphere",
  panelMultiPhyMeshTBox = "Box",
  panelMultiPhyMeshTCapsule = "Capsule",
  panelMultiPhyMeshTConvex = "Convex",
  panelMultiPhyMeshTComposite = "Concave",
  panelMultiPhyMeshTOriginal = "Original",
  panelMultiPhyMeshTCustom = "Custom",
  panelMultiPhyMeshTMulti = "(Multiple Meshes)",
  panelMultiPhyMeshParam = "Physical Mesh Parameters",
  panelMultiPhyMeshParamRadius = "Radius",
  panelMultiPhyMeshParamLength = "Length",
  panelMultiPhyMeshParamWidth = "Width",
  panelMultiPhyMeshParamHeight = "Height",
  panelMultiPhyMeshParamVertCount = "% Vertices in Mesh",
  panelMultiPhyMeshParamInflation = "Inflation",
  panelMultiPhyMeshParamGenerateFrom = "Generate From",
  panelMultiPhyMeshParamGenerateNow = "Regenerate from Original",
  panelMultiPhyMeshParamVerts = "Vertices",
  panelMultiPhyMeshParamVertCountUnmatch ="(Unmatching Vertex Count)",

  panelMultiPhyMeshParamCompositeMaxConcavity = "Mesh Detail",
  panelMultiPhyMeshParamPercent = "%",
  panelMultiPhyMeshParamAdvancedGroup = "Advanced Parameters",
  panelMultiPhyMeshParamSmallClusterThreshold = "Min. Hull Size",
  panelMultiPhyMeshParamCompositeMaxVertices = "Max. Verts Per Hull",
  panelMultiPhyMeshParamCompositeHighQualityTT =
    "Better fitting for objects with holes or high curvature.  Disable for improved performance.",
  panelMultiPhyMeshParamCompositeHighQuality = "Improve Fitting",
  panelMultiPhyMeshParamHullsFormat  = "Current Mesh Contains % Hulls",
  panelMultiPhyMeshParamHullsUnmatch ="(Unmatching Hull Count)",
  panelMultiPhyMeshParamGenerate = "Generate",

  panelMultiPhyMeshParamCalculating = "Calculating... Please Wait",
  panelMultiPhyMeshParamNoParam = "This mesh type has no parameters",
  panelMultiPhyMeshParamPickSource = "Pick Source Object",
  panelMultiPhyMeshParamSelectSource = "Select Source Object",
  panelMultiPhyMeshParamExtractToSource = "Extract To Source Object",
  panelMultiPhyMeshParamUpdateFromSource = "Update From Source Object",
  panelMultiAdvanced = "Advanced",
  panelMultiAdvancedSim = "Simulation",
  panelMultiAdvancedCollOverlap = "Override Collision Overlap",
  panelMultiAdvancedSolverIter = "Override Solver Iterations",
  panelMultiAdvancedEnableBackfaceCollision = "Enable Backface Collision",
  panelMultiAdvancedContactShell = "Contact Shell",
  panelMultiAdvancedContactShellLegacyMode = "Legacy Mode",
  panelMultiAdvancedContactShellOverride = "Override Globals",
  panelMultiAdvancedContactShellContactDistance = "Contact Distance",
  panelMultiAdvancedContactShellRestDepth = "Rest Depth",
  panelMultiAdvancedIniMotion = "Initial Motion",
  panelMultiAdvancedIniVel = "Initial Velocity",
  panelMultiAdvancedX = "X",
  panelMultiAdvancedY = "Y",
  panelMultiAdvancedZ = "Z",
  panelMultiAdvancedSpeed = "Speed",
  panelMultiAdvancedIniSpin = "Initial Spin",
  panelMultiAdvancedCenterOfMass = "Center of Mass",
  panelMultiAdvancedCOMCalculateFromMeshes = "Calculate From Meshes",
  panelMultiAdvancedCOMUsePivot = "Use Pivot",
  panelMultiAdvancedCOMLocalOffset = "Local Offset",
  panelMultiAdvancedDamping = "Damping",
  panelMultiAdvancedLinear = "Linear",
  panelMultiAdvancedAngular = "Angular",
  panelMultiAdvancedAbs = "Absolute",
  panelMultiAdvancedRel = "Relative",

  panelMultiForces = "Forces",
  panelMultiForcesGravity = "Use World Gravity",
  panelMultiForcesList = "Scene Forces Applied:",
  panelMultiForcesAdd = "Add",
  panelMultiForcesRemove = "Remove",
  panelMultiForcesDeletedItem = "<deleted>",  


  panelMultiConstraintGeneral = "General",
  panelMultiConstraintTranslationLimits = "Translation Limits",
  panelMultiConstraintSwingTwistLimits = "Swing & Twist Limits",
  panelMultiConstraintSpring = "Spring",
  panelMultiConstraintAdvanced = "Advanced",
  panelMultiConstraintBehavior = "Behavior",
  panelMultiConstraintUseAcceleration = "Constraint Behavior",
  panelMultiConstraintUseAccelerationOn = "Use Acceleration",
  panelMultiConstraintUseAccelerationOff = "Use Force",
  panelMultiConstraintUseHardLimits = "Constraint Limits",
  panelMultiConstraintUseHardLimitsOn = "Hard Limits",
  panelMultiConstraintUseHardLimitsOff = "Soft Limits",
  panelMultiConstraintHelperSize = "Icon Size",
  panelMultiConstraintLocked = "Locked",
  panelMultiConstraintLimited = "Limited",
  panelMultiConstraintFree = "Free",
  panelMultiConstraintRowX = "X",
  panelMultiConstraintRowY = "Y",
  panelMultiConstraintRowZ = "Z",
  panelMultiConstraintRowLabelSpacing = "         ",
  panelMultiConstraintModeLabelSpacing = "          ",
  panelMultiConstraintLimitRadius = "Limit Radius",
  panelMultiConstraintBounce = "Bounce",
  panelMultiConstraintDamping = "Damping",
  panelMultiConstraintSwingY = "Swing Y",
  panelMultiConstraintSwingZ = "Swing Z",
  panelMultiConstraintTwist = "Twist",
  panelMultiConstraintAngleLimit = "Angle Limit",
  panelMultiConstraintLimitLeft = "Left",
  panelMultiConstraintLimitRight = "Right",
  panelMultiConstraintTwistLimit = "Limit",
  panelMultiConstraintSpringPosition = "Spring To Resting Position",
  panelMultiConstraintSpringSwing = "Spring To Resting Swing",
  panelMultiConstraintSpringTwist = "Spring To Resting Twist",
  panelMultiConstraintSpringiness = "Springiness",
  panelMultiConstraintParentChildCollisions = "Parent/Child Collisions",
  panelMultiConstraintBreakableConstraint = "Breakable Constraint",
  panelMultiConstraintBreakable = "Breakable",
  panelMultiConstraintBreakForce = "Break Force",
  panelMultiConstraintBreakTorque = "Break Torque",
  panelMultiConstraintProjection = "Projection",
  panelMultiConstraintProjectionType = "Projection Type",
  panelMultiConstraintProjectionNone = "No Projection",
  panelMultiConstraintProjectionLinear = "Linear",
  panelMultiConstraintProjectionLinAngular = "Linear and Angular",
  panelMultiConstraintProjectionSettings = "Projection Settings",
  panelMultiConstraintProjectionDistance = "Distance",
  panelMultiConstraintProjectionAngle = "Angle",
  panelMultiConstraintBehaviorGroup = "Behavior",

  physXPanelSceneX = "X",
  physXPanelSceneY = "Y",
  physXPanelSceneZ = "Z",
  physXPanelUndoUseGround = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Use Ground Collisions edit" else
    "PhysX Tools Use Ground Collisions edit"),
  physXPanelUndoGravityEnabled = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Gravity Enabled edit" else
    "PhysX Tools Gravity Enabled edit" ),
  physXPanelUndoGravity = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Gravity edit" else
    "PhysX Tools Gravity edit" ),
  physXPanelUndoSleepSpeed = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Sleep Speed edit" else
    "PhysX Tools Sleep Speed edit"),
  physXPanelUndoSleepSpin = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Sleep Spin edit" else
    "PhysX Tools Sleep Spin edit"),
  physXPanelUndoSkinWidth = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Skin Width edit" else
    "PhysX Tools Skin Width edit"),
  physXPanelUndoSolverIter = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Solver Iteration edit" else
    "PhysX Tools Solver Iteration edit"),
  physXPanelUndoSubsteps = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Substeps edit" else
    "PhysX Tools Substeps edit"),
  physXPanelUndoUseHVC = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Use High Velocity Collisions edit" else
    "PhysX Tools Use High Velocity Collisions edit"),
  physXPanelUndoSleepThresholdAuto = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Sleep Threshold Automatic edit" else
    "PhysX Tools Sleep Threshold Automatic edit"),
  physXPanelUndoHVCAuto = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools High Velocity Collisions Automatic edit" else
    "PhysX Tools High Velocity Collisions Automatic edit"),
  physXPanelUndoHVCThreshold = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools High Velocity Collisions Threshold edit" else
    "PhysX Tools High Velocity Collisions Threshold edit"),
  physXPanelUndoBounceMinAuto = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Bounce Min Speed Automatic edit" else
    "PhysX Tools Bounce Min Speed Automatic edit"),
  physXPanelUndoBounceMinThreshold = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Bounce Min Speed Threshold edit" else
    "PhysX Tools Bounce Min Speed Threshold edit"),
  physXPanelUndoOnLastFrame = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools On Last Frame edit" else
    "PhysX Tools On Last Frame edit"),
  physXPanelUndoLoopAnim = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Loop Animation edit" else
    "PhysX Tools Loop Animation edit"),
  physXPanelUndoUseMultithread = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Use Multithreading edit" else
    "PhysX Tools Use Multithreading edit"),
  physXPanelUndoHardware = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Use Hardware Acceleration edit" else
    "PhysX Tools Use Hardware Acceleration edit"),
  physXPanelUndoBakeAll = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Bake All" else
    "PhysX Tools Bake All"),
  physXPanelUndoBakeSelected = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Bake Selected" else
    "PhysX Tools Bake Selected"),
  physXPanelUndoUnbakeAll = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Unbake All" else
    "PhysX Tools Unbake All"),
  physXPanelUndoUnbakeSelected = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Unbake Selected" else
    "PhysX Tools Unbake Selected"),
  physXPanelUndoDisplayPhyMesh = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Tools Display Physical Meshes edit" else
    "PhysX Tools Display Physical Meshes edit"),
  physXPanelUndoVisEnable = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Visualizer Enable edit" else
    "PhysX Visualizer Enable edit"),
  physXPanelUndoVisScale = (if PHYSX_AUTODESK_VER!=undefined then
    "MassFX Visualizer Scale edit" else
    "PhysX Visualizer Scale edit"),
  physXPanelGravityNone = "No Gravity",
  physXPanelGravitySettings = "Directional Gravity",
  physXPanelGravityForce = "Gravity by Force Object",
  physXPanelPickGravity = "Pick Gravity",
  physXPanelGravityForceMsg = "Pick a Gravity Object to act as Global Gravity",
  
  panelMultiConvexParamSurface = "Surface",
  panelMultiConvexParamVertices = "Vertices",

  ragdollErrorNoRoot = (if PHYSX_AUTODESK_VER!=undefined then
    "Error: unknown Skeleton. Can not find its root bone!" else
    "Error: unknown Ragdoll. Can not find its root bone!"),
  ragdollDeleteRB = (if PHYSX_AUTODESK_VER!=undefined then
    "Delete the MassFX Rigid Bodies associated with this Skeleton?" else
    "Delete the PhysX Rigid Bodies associated with this Ragdoll?"),

  toolsDlgTitle = "Tools",
  toolsDlgPageWorld = "World Parameters",
  toolsDlgPageTools = "Simulation Tools",
  toolsDlgPageDisplay = "Display Options",
  toolsDlgPageEdit = "Multi-Object Editor",
  toolsDlgSceneSettings = "Scene Settings",
  toolsDlgUseGround = "Use Ground Collisions",
  toolsDlgUseGroundTooltip = "Add an invisible static plane at Z=0.",
  toolsDlgGlobalGravity = "Global Gravity",
  toolsDlgGravityEnabled = "Gravity Enabled",
  toolsDlgGravityEnabledTooltip = "Check to enable gravity on all rigid bodies.",
  toolsDlgGravityDirection = "Axis",
  toolsDlgGravityNone = "No Gravity",
  toolsDlgGravityDirectionTooltip = "Global axis along which gravity will be applied.",
  toolsDlgGravityAcceleration = "Acceleration",
  toolsDlgGravityAccelerationTooltip = "Force of gravity in cm/s^2. (Negative to inverse gravity)",
  toolsDlgRigidbodies = "Rigid Bodies",
  toolsDlgRigidBodySubsteps = "Substeps",
  toolsDlgRigidBodySubstepsTooltip = "Enter no. of simulation steps performed between each graphical update.",
  toolsDlgRigidBodySolver = "Solver Iter.",
  toolsDlgRigidBodySolverTooltip = "No. of solver iterations to enforce collisions and constraints.",
  toolsDlgRigidBodyCollisionOverlap = "Collision Overlap",
  toolsDlgRigidBodyCollisionOverlapTooltip = "Distance that rigid bodies are allowed to penetrate one another.",
  toolsDlgRigidBodyEnableHighVelocity = "Use High Velocity Collisions",
  toolsDlgRigidBodyEnableHighVelocityTooltip = "Enable Continuous Collision Detection.",
  toolsDlgAdvancedSettings = "Advanced Settings",
  toolsDlgSleepSettings = "Sleep Settings",
  toolsDlgAutomatic = "Automatic",
  toolsDlgManual = "Manual",
  toolsDlgSleepAutomaticTooltip = "Automatically use reasonable values for both \"Sleep Threshold\" linear and angular velocities.",
  toolsDlgSleepManualTooltip = "Select to override automatic with custom values for both \"Sleep Threshold\" linear and angular velocities.",
  toolsDlgSleepSpeedTooltip = "Enter minimum sleep linear velocity.",
  toolsDlgSleepSpinTooltip = "Enter minimum sleep angular velocity.",
  toolsDlgMinSpeed = "Min Speed",
  toolsDlgMinSpin = "Min Spin",
  toolsDlgCCDAutomaticTooltip = "Automatically use reasonable speed values above which CCD is applied.",
  toolsDlgCCDManualTooltip = "Select to override automatic with custom values for CCD speed.",
  toolsDlgCCDMinSpeedTooltip = "Enter minimum speed for CCD Threshold.",
  toolsDlgHighVelocityCollisions = "High Velocity Collisions",
  toolsDlgBounceSettings = "Bounce Settings",
  toolsDlgBounceAutomaticTooltip = "Automatically use reasonable speed values for Bounce Threshold.",
  toolsDlgBounceManualTooltip = "Select to override automatic with custom values for Bounce speed.",
  toolsDlgBounceMinSpeedTooltip = "Enter minimum speed for Bounce Threshold.",
  toolsDlgSimulationSettings = "Simulation Settings",
  toolsDlgPlayback = "Playback",
  toolsDlgOnLastFrame = "On Last Frame",
  toolsDlgContinueSimulation = "Continue Simulation",
  toolsDlgContinueSimulationTooltip = "Continue PhysX simulation after last frame.", 
  toolsDlgStopSimulation = "Stop Simulation",
  toolsDlgStopSimulationTooltip = "Stop PhysX simulation at last frame.",
  toolsDlgLoopAnimationAnd = "Loop Animation and...",
  toolsDlgLoopAnimationAndToolTip = "Loop Max animation.",
  toolsDlgResetSimulation = "Reset Simulation",
  toolsDlgResetSimulationTooltip = "Reset PhysX simulation at last frame.",
  toolsDlgEngine = "Engine",
  toolsDlgOptions = "Options",
  toolsDlgUseMultithreading = "Use Multithreading",
  toolsDlgUseMultithreadingTooltip = "Use multiple cores to speed simulation (may cause variations between simulations)",
  toolsDlgHardwareAcceration = "Hardware Acceleration",
  toolsDlgHardwareAccerationTooltip = "Use GPU to speed simulation (may cause variations between simulations)",
  toolsDlgVersion = "Version",
  toolsDlgAbout = "About",
  toolsDlgSimulation = "Simulation",
  toolsDlgReset = "Reset",
  toolsDlgResetTooltip = "Reset Simulation",
  toolsDlgPlay = "Start",
  toolsDlgPlayTooltip = "Start Simulation",
  toolsDlgPNA = "PNA",
  toolsDlgPNAToolTip = "Start Simulation Without Animation",
  toolsDlgStep = "Step",
  toolsDlgStepTooltip = "Step Simulation",
  toolsDlgSimulationBaking = "Simulation Baking",
  toolsDlgBakeAll = "Bake All",
  toolsDlgBakeSelected = "Bake Selected",
  toolsDlgUnbakeAll = "Unbake All",
  toolsDlgUnbakeSelected = "Unbake Selected",
  toolsDlgModeling = "Capture Transforms",
  toolsDlgCaptureTransform = "Capture Selected",
  toolsDlgUtilities = "Utilities",
  toolsDlgScene = "Scene",
  toolsDlgValidateScene = "Validate Scene",
  toolsDlgExploreScene = "Explore Scene",
  toolsDlgExportScene = "Export Scene",
  toolsDlgRBDisplay = "Rigid Bodies", 
  toolsDlgRBDisplayPhyMesh = "Display Physical Meshes", 
  toolsDlgRBDisplaySelOnly = "Selected Objects Only",
  toolsDlgPhysicalMeshes = "Physical Meshes",
  toolsDlgShowOnlySelected = "Show Only for Selected",
  toolsDlgShowAllPhysicalMeshes = "Show All Physical Meshes",
  toolsDlgHideAllPhysicalMeshes = "Hide All Physical Meshes",
  toolsDlgShowPhysicalMeshesTooltip = "Show/Hide physical meshes in viewport.",

	-- px_exporterRollout.ms use the following text
	guiExportGeneralSettings = "General Settings",
	guiExportFolderName = "Folder Name",
	guiExportIncludeFbx = "Include FBX",
	
	guiExportSceneSettings = "PhysX Scene Settings",
	guiExportScene = "Export PhysX Scene",
	guiExportFileFormat = "File Format",
	guiExportXML = "XML",
	guiExportBinary = "Binary",
	
	guiExportClothingSettings = "APEX Clothing Settings",
	guiExportClothing = "Export APEX Clothing",
	guiExportAlsoExport = "Also Export",
	guiExportTriangleWinding = "Triangle Winding",
	guiExportIncludeCollisionHulls = "Include collision hulls",
	guiExportOmitMeshSubpartNames = "Omit mesh subpart names",
	
	guiExportDestructionSettings = "APEX Destruction Settings",
	guiExportDestruction = "Export APEX Destruction",
	
	guiExportOptions = "PhysX Export Options",
	guiExportValidateScene = "Validate scene before export",
	guiOnlyExportSelected = "Only export selected objects",
	guionlyExportVisible = "Only export visible objects",
	guiExportExport = "Export",
	guiExportCancel = "Cancel",

	/*global*/
	-----------------------------------
	TXT_MENU_NAME		= "PhysX",
	
	-- following variables should be kept identical to strings in the resource file
	TXT_CATEGORY		= "NVIDIA PhysX",		
	TXT_CLOTHING_CLASS	= "APEX Clothing",
	TXT_SBCLOTHING_CLASS= "APEX Softbody",
	TXT_LOD_CLASS		= "APEX LoD",
	TXT_RAGDOLL_NAME	= "PhysX Ragdoll",
	TXT_D6HELPER_NAME	= "PhysX Constraint",
		
	/*px_bake*/
	-----------------------------------
	TXT_BAKE_BAKING_CLOTH = "PhysX baking clothing...",
	TXT_BAKE_BAKING_RB = "PhysX baking...",

	/*px_common*/
	-----------------------------------
	TXT_COMMON_WARN = "PhysX Warning: not enough keys to extract any useful info!\n",

	/*px_compatibility*/
	-----------------------------------
	TXT_COMPATIBILITY_QUERY_CONVERT = "The Max file is made of old PhysX Plugin. Do you want to convert to current version?",
	TXT_COMPATIBILITY_INFO_RENMAE = "The Max has been converted to current PhysX version. Please manually rename this file if you do not want to overwrite the old one.",
	TXT_COMPATIBILITY_NOTICE_DELETE = "Note: RB modifier of '%' is broken. Delete it.\n",

	/*px_exportClothing*/
	-----------------------------------
	TXT_EXPORTCLOTHING_CONVERT_FOLDER = "Select a folder of Max files to convert.",
	TXT_EXPORTCLOTHING_EXPORT_FOLDER = "Select a folder to export to.",
	TXT_EXPORTCLOTHING_EXP_INFO_FMT = "Export APEX Clothing: \"%\"\n",
	TXT_EXPORTCLOTHING_EXP_DONE_FMT = "Export APEX Clothing: % file(s) processed.\n",

	/*px_globals*/
	-----------------------------------
	TXT_GLOBALS_ERROR = "Error",
	TXT_GLOBALS_WARN_UNKNOWN_UNIT = "Unknown unit enum value: %!\n",
	TXT_GLOBALS_FAIL_ALIGN_PIVOT = "failed in pxScaleTools.alignPivotNodeAndProxy node = %, proxy = %.",
	TXT_GLOBALS_NOTICE_ADD_PART1 = "PhysX Notice: add ",
	TXT_GLOBALS_NOTICE_ADD_PART2 = " physics objects in total.",
	TXT_GLOBALS_NOTICE_ADD_PART3 = " rigid bodies.",
	TXT_GLOBALS_NOTICE_ADD_PART4 = " constraints.",
	TXT_GLOBALS_WARN_NO_DLM = "PhysX Warning:  unable to call function nvpx.InitializePhysX from PXPLUGIN.DLM, the plugin might not be correctly installed.",
	TXT_GLOBALS_NOTE_SKIP_GROUP = "Note: skip group node '%'\n",
	TXT_GLOBALS_SHOW_VIEWER = "Showing Viewer\n",
	TXT_GLOBALS_PROMPT_TOOL_SIZE_CONST = "Size Constraint",
	TXT_GLOBALS_ERR_CREATE_CONST_AT = "Error: PxCreateConstraintAt(), impossible case.\n",
	TXT_GLOBALS_MSG_NO_STATIC_RB = "Static rigid bodies may not be used as part of a constraint.",
	TXT_GLOBALS_MSG_NO_SUPPORT_KINE = "PhysX does not support constraints to a single kinematic rigid body.",
	TXT_GLOBALS_QUERY_APP_RB_PART2 = " and ",
	TXT_GLOBALS_MSG_NO_SUPPORT_KINE2 = "PhysX does not support making a constraint with two Kinematic Rigid Bodies.",
	TXT_GLOBALS_QUERY_DEL_RB = "Delete the PhysX Rigid Bodies associated with this Ragdoll?",
	TXT_GLOBALS_IMP_CTW_DLG_TITLE = "Select .ctw file to import... ",
	TXT_GLOBALS_IMPORT_ERR_FMT = "Error importing &\n",
	TXT_GLOBALS_EXP_CTW_DLG_TITLE = "Choose where to export .ctw file to.. ",
	TXT_GLOBALS_EXPORT_ERR_FMT = "Error exporting &\n",

	/*px_guiD6*/
	-----------------------------------
	TXT_GUID6_MSG_IDENT_NODES = "The two nodes connecting to Constraint should be different.",
	TXT_GUID6_MSG_NO_HELPER = "Helper node can not be set as part of PhysX Constraint.",
	TXT_GUID6_MSG_INVALID_TWO_KINE = "It is not valid that two Kinematic Rigid Bodies connect to a constraint.",
	TXT_GUID6_MSG_NOT_RB = " is not a Dynamic or Kinematic Rigid Body.",
	TXT_CONSTRAINT_QUERY_MUSTBERB = "Objects connected by a constraint must be Rigid Bodies.\n",
	TXT_CONSTRAINT_QUERY_APPLYRBMTO1 = "Apply a MassFX Rigid Body modifier to %?",
	TXT_CONSTRAINT_QUERY_APPLYRBMTO2 = "Apply a MassFX Rigid Body modifier to % and %?",
	TXT_CONSTRAINT_MSG_STATICRBNOTPARTOFCONSTRAINT = "Static rigid bodies may not be used as part of a constraint.",
	TXT_CONSTRAINT_MSG_CONSTRAINTWITH2KRB = "MassFX does not support making a constraint with two Kinematic Rigid Bodies.",

	/*px_guiMenuToolbar*/
	-----------------------------------
	TXT_GUIMENUTOOLBAR_VER_UNKNOWN = "unknown",
	TXT_GUIMENUTOOLBAR_VER_273 = "2.7.3",
	TXT_GUIMENUTOOLBAR_VER_280 = "2.8.0",
	TXT_GUIMENUTOOLBAR_VER_281 = "2.8.1",
	TXT_GUIMENUTOOLBAR_VER_283 = "2.8.3",
	TXT_GUIMENUTOOLBAR_VER_284 = "2.8.4",
	TXT_GUIMENUTOOLBAR_VER_285 = "2.8.5",
	TXT_GUIMENUTOOLBAR_VER_300 = "3.1.0",
	TXT_GUIMENUTOOLBAR_NO_SUPPORT_OBJ = "PhysX does not support making Group object as Cloth. They are unchanged.",
	TXT_GUIMENUTOOLBAR_NO_SUPPORT_HELPER = "PhysX does not support Helpers. Helpers are unchanged.",
	TXT_GUIMENUTOOLBAR_FILETYPE_BIN = "Binary",
	TXT_GUIMENUTOOLBAR_FILETYPE_COLLADA = "Collada",
	TXT_GUIMENUTOOLBAR_INFO_EXP_FAIL_FMT = "Export to '%' failed.\n",
	TXT_GUIMENUTOOLBAR_INFO_EXP_OK_FMT = "Scene is exported to '%'.\n",
	TXT_GUIMENUTOOLBAR_SAVE_FMT_XML = "NxuStream XML",
	TXT_GUIMENUTOOLBAR_SAVE_FMT_REPX = "PhysX 3.1 RepX",
	TXT_GUIMENUTOOLBAR_SAVE_FMT_BIN = "NxuStream BINARY",
	TXT_GUIMENUTOOLBAR_SAVE_FMT_COLLADA = "COLLADA",

	/*px_guiRagdoll*/
	-----------------------------------
	TXT_GUIRAGDOLL_INFO_EXTRA_SHAPE = " extra shapes for ",
	TXT_GUIRAGDOLL_NODE_INFO_FMT = " mBoneNodes = %\n",
	TXT_GUIRAGDOLL_HANDLE_INFO_FMT = " mBoneHandles = %\n",
	TXT_GUIRAGDOLL_FLAG_INFO_FMT = " mBoneFlags = %\n",
	TXT_GUIRAGDOLL_GID_INFO_FMT = " mBoneGroupIDs = %\n",
	TXT_GUIRAGDOLL_GROUP_INFO_FMT = " boneGroups = %\n",
	TXT_GUIRAGDOLL_ERR_UNKNOWN_RAG = "Error: unknown Ragdoll! Can not find its root bone or its skin!\n",
	TXT_GUIRAGDOLL_NOTE_MORE_VERT = "Note: Bone '%' does not have enough associated vertices to create a convex hull. Use capsule hull.\n",
	TXT_GUIRAGDOLL_NEW_HULL_FMT = "Hull for $'%' is created.\n",
	TXT_GUIRAGDOLL_GROUP = "Group",
	TXT_GUIRAGDOLL_REGEN_BONES = "Regenerate Selected Bones",
	TXT_GUIRAGDOLL_REGEN_BONE = "Regenerate Selected Bone",
	TXT_GUIRAGDOLL_PROMPT_SEL = "Selecting - ",
	TXT_GUIRAGDOLL_PROMPT_CREATE_RAG = "Ragdoll Creation",
	TXT_GUIRAGDOLL_GEN_DONE = "Ragdoll is generated.\n",

	/*px_guiShowMenu*/
	-----------------------------------
	TXT_GUISHOWMENU_NO_FLUID = "fluid will be supported later",
	TXT_GUISHOWMENU_NO_EMITTER = "emitter will be supported later",
	TXT_GUISHOWMENU_MENUNAME_PHYSX = TXT_MENU_NAME,
	TXT_GUISHOWMENU_HELP = "PhysX Plug-in Help...",
	TXT_GUISHOWMENU_SHOW_UI = "Show UI",
	TXT_GUISHOWMENU_SIMULATION = "Simulation",
	TXT_GUISHOWMENU_RB = "Rigid Bodies",
	TXT_GUISHOWMENU_CONSTRAINTS = "Constraints",
	TXT_GUISHOWMENU_RAGDOLLS = "Ragdolls",
	TXT_GUISHOWMENU_CLOTHING = "APEX Clothing",
	TXT_GUISHOWMENU_DESTRUCTION = "APEX Destruction",
	TXT_GUISHOWMENU_FORCES = "Forces ",
	TXT_GUISHOWMENU_HAMMER = "Use Hammer",
	TXT_GUISHOWMENU_BOMB = "Use Radial Damage",
	TXT_GUISHOWMENU_VALIDATE = "Validate PhysX Scene...",
	TXT_GUISHOWMENU_EXPORT = "Export PhysX Scene...",
	TXT_GUISHOWMENU_SWITCH_TO_SDK_300 = "Switch PhysX 2.x to 3.x",
	TXT_GUISHOWMENU_SWITCH_TO_SDK_284 = "Switch PhysX 3.x to 2.x",
	TXT_GUISHOWMENU_ABOUT = "About PhysX Plug-in...",
	TXT_GUISHOWMENU_TOOLBAR = "Show PhysX Toolbar",
	TXT_GUISHOWMENU_TOOLS = "Show PhysX Tools",
	TXT_GUISHOWMENU_RUN = "Run Simulation",
	TXT_GUISHOWMENU_STEP = "Step Simulation",
	TXT_GUISHOWMENU_RESET = "Reset Simulation",
	TXT_GUISHOWMENU_DYNAMIC_RB = "Set Selected as Dynamic Rigid Body",
	TXT_GUISHOWMENU_KINEMATIC_RB = "Set Selected as Kinematic Rigid Body",
	TXT_GUISHOWMENU_STATIC_RB = "Set Selected as Static Rigid Body",
	TXT_GUISHOWMENU_INIT_TRANS = "Capture Initial Transforms",
	TXT_GUISHOWMENU_SEL_TRANS = "Capture Selected Initial Transforms",
	TXT_GUISHOWMENU_BAKE_ALL = "Bake All Dynamic to Keyframes",
	TXT_GUISHOWMENU_BAKE_SEL = "Bake Selected to Keyframes",
	TXT_GUISHOWMENU_UNBAKE_ALL = "Unbake All Dynamic",
	TXT_GUISHOWMENU_UNBAKE_SEL = "Unbake Selected Dynamic",
	TXT_GUISHOWMENU_RIGID_CONSTR = "Create Rigid Constraint",
	TXT_GUISHOWMENU_SLIDE_CONSTR = "Create Slide Constraint",
	TXT_GUISHOWMENU_HINGE_CONSTR = "Create Hinge Constraint",
	TXT_GUISHOWMENU_TWIST_CONSTR = "Create Twist Constraint",
	TXT_GUISHOWMENU_UNIV_CONSTR = "Create Universal Constraint",
	TXT_GUISHOWMENU_BALL_CONSTR = "Create Ball && Socket Constraint",
	TXT_GUISHOWMENU_DYNAMIC_RAG = "Create Dynamic Ragdoll",
	TXT_GUISHOWMENU_KINEMATIC_RAG = "Create Kinematic Ragdoll",
	TXT_GUISHOWMENU_RM_RAG = "Remove Ragdoll",
	TXT_GUISHOWMENU_NEW_CLOTHING = "Create Clothing",
	TXT_GUISHOWMENU_NEW_DESTRUCTION = "Create Destruction",
	TXT_GUISHOWMENU_NEW_SBCLOTHING=	"Create Softbody",
	TXT_GUISHOWMENU_IMPORT_CLOTH = "Import Clothing Template...",
	TXT_GUISHOWMENU_EXPORT_CLOTH = "Export Clothing Template...",
	TXT_GUISHOWMENU_REBUILD_SEL = "Rebuild Selected Clothing",

	/*px_modifierClothing*/
	-----------------------------------
	TXT_MODIFIERCLOTHING_CLOTHING_CLASS_NAME = TXT_CLOTHING_CLASS,
	TXT_MODIFIERCLOTHING_LOD_CLASS_NAME = TXT_LOD_CLASS,
	TXT_MODIFIERCLOTHING_SBCLOTHING_CLASS_NAME = TXT_SBCLOTHING_CLASS,
	TXT_MODIFIERCLOTHING_FAIL_TO_ADD = "Can't add clothing modifier to object without skin!",
	TXT_MODIFIERCLOTHING_INFO_SAVING_FMT = "Saving '%'.\n",

	/*px_modifierRB*/
	-----------------------------------
	TXT_MODIFIERRB_NOT_GEOM = "Some node(s) in selection are not Geometry nodes!",

	/*px_ragdoll*/
	-----------------------------------
	TXT_RAGDOLL_ERR_UNKNOWN = "Error: unknown Ragdoll. Can not find its root bone!",
	TXT_RAGDOLL_QUERY_DEL = "Delete the PhysX Rigid Bodies associated with this Ragdoll?",

	/*px_modifierCloth*/
	-----------------------------------
	TXT_MODIFIERCLOTH_NOT_ALLOWED = "Some node(s) in selection are not Geometry nodes!",

	/*px_unitchanges*/
	-----------------------------------
	TXT_UNITCHANGES_INFO_UNKNOWN = " Unknown unit type!\n",
	
	/*name size error*/
	TXT_ERROR_NAME_SIZE = "Name shouldn't be empty or larger than 128 characters",

	/*px_watcher*/
	-----------------------------------
	TXT_WATCHER_MENUNAME_PHYSX = "PhysX",
	TXT_WATCHER_INFO = "NVIDIA PhysX Physics Utilities and Exporter Loaded",

	/*px_exportClothing*/
	-----------------------------------
	UI_EXPORTCLOTH_BTN_EXP = "Export APEX Clothing",
	UI_EXPORTCLOTH_TT_EXP = "Batch Export APEX Clothing from all of the Max files in a same folder",
	
	/*px_PhysXPanel*/
	-----------------------------------	
	UI_PANEL_TITLE = "Tools",
	UI_PANEL_PAGE_WORLD = "World",
	UI_PANEL_PAGE_TOOL = "Tools",
	UI_PANEL_PAGE_DISPLAY = "Display",
	UI_PANEL_SETTINGS_TITLE = "Scene Settings",
	UI_PANEL_BT_USEADAPTIVEFORCE = "Use Adaptive Force",
	UI_PANEL_TT_USEADAPTIVEFORCE = "When true, more stable when many rigid bodies are colliding as a pile or cluster",
	UI_PANEL_BT_GENERATESHAPEPERELEM = "Generate Shape Per Element",
	UI_PANEL_BT_USEGROUND = "Use Ground Collisions",
	UI_PANEL_LB_GROUND_HEIGHT = "Ground Height",
	UI_PANEL_TT_GROUNDHEIGHT = "Height of physical ground plane placement in Z-axis",
	UI_PANEL_TT_USEGROUND = "Add an invisible static plane at Z=0.",
	UI_PANEL_LB_ENVIRONMENT = "Environment",
	UI_PANEL_CB_ENABLEGRAVITY = "Gravity Enabled",
	UI_PANEL_TT_ENABLEGRAVITY = "Check to enable gravity on all rigid bodies.",
	UI_PANEL_LB_DIRECTION = "Direction",
	UI_PANEL_TT_DIRECTION = "Global axis along which gravity will be applied.",
	UI_PANEL_LB_ACC = "Acceleration",
	UI_PANEL_TT_ACC = "Force of gravity in cm/s^2. (Negative to inverse gravity)",
	UI_PANEL_RB_TITLE = "Rigid Bodies",
	UI_PANEL_LB_SUBSTEP = "Substeps",
	UI_PANEL_TT_SUBSTEP = "Enter no. of simulation steps performed between each graphical update.",
	UI_PANEL_LB_SI = "Solver Iter.",
	UI_PANEL_TT_SI = "No. of solver iterations to enforce collisions and constraints.",
	UI_PANEL_LB_OVERLAP = "Collision Overlap",
	UI_PANEL_TT_OVERLAP = "Distance that rigid bodies are allowed to penetrate one another.",
	UI_PANEL_CB_ENABLECCD1 = "Use High Velocity Collisions",
	UI_PANEL_TT_ENABLECCD = "Enable Continuous Collision Detection.",
	UI_PANEL_ADV_TITLE = "Advanced Settings",
	UI_PANEL_GROUP_SLEEPSET = "Sleep Settings",
	UI_PANEL_RB_AUTO = "Automatic",
	UI_PANEL_RB_MANUAL = "Manual",
	UI_PANEL_TT_AUTOSPEED = "Automatically use reasonable values for both \"Sleep Threshold\".",
	UI_PANEL_TT_MANUALSPEED = "Select to override automatic with custom values for both \"Sleep Threshold\".",
	UI_PANEL_TT_SLEEP_ENERGY = "Mass invariant sleep energy.",
	UI_PANEL_TT_ENTER_MINV = "Enter minimum sleep linear velocity.",
	UI_PANEL_TT_ENTER_MINSPIN = "Enter minimum sleep angular velocity.",
	UI_PANEL_LB_MINSPEED = "Min Speed",
	UI_PANEL_LB_MINSPIN = "Min Spin",
	UI_PANEL_LB_SLEEP_ENERGY = "Sleep Energy",
	UI_PANEL_TT_AUTOCCD = "Automatically use reasonable speed values above which CCD is applied.",
	UI_PANEL_TT_MANUALCCD = "Select to override automatic with custom values for CCD speed.",
	UI_PANEL_TT_ENTER_MINCCD = "Enter minimum speed for CCD Threshold.",
	UI_PANEL_GROUP_CCD = "High Velocity Collisions",
	UI_PANEL_GROUP_BOUNCE = "Bounce Settings",
	UI_PANEL_TT_AUTOBOUNCE = "Automatically use reasonable speed values for Bounce Threshold.",
	UI_PANEL_TT_MANUALBOUNCE = "Select to override automatic with custom values for Bounce speed.",
	UI_PANEL_TT_ENTER_MINB = "Enter minimum speed for Bounce Threshold.",
	UI_PANEL_SIM_TITLE = "Simulation Settings",
	UI_PANEL_GROUP_PLAYBACK = "Playback",
	UI_PANEL_LB_ONLAST = "On Last Frame",
	UI_PANEL_RB_CONTINUE = "Continue Simulation",
	UI_PANEL_TT_CONTINUE = "Continue PhysX simulation after last frame.", 
	UI_PANEL_RB_STOP = "Stop Simulation",
	UI_PANEL_TT_STOP = "Stop PhysX simulation at last frame.",
	UI_PANEL_RB_LOOP = "Loop Animation and...",
	UI_PANEL_TT_LOOP = "Loop Max animation.",
	UI_PANEL_RB_LOOPRESET = "Reset Simulation",
	UI_PANEL_TT_LOOPRESET = "Reset PhysX simulation at last frame.",
	UI_PANEL_ENTINE_TITLE = "Engine",
	UI_PANEL_GROUP_OPTIONS = "Options",
	UI_PANEL_LBL_SWITCH_SDK = "Use PhysX Engine",
	UI_PANEL_TT_SWITCH_SDK = "Choose PhysX Engine Version",
	UI_PANEL_CB_MT = "Use Multithreading",
	UI_PANEL_TT_MT = "Use multiple cores to speed simulation (may cause variations between simulations)",
	UI_PANEL_CB_HWACC = "Hardware Acceleration",
	UI_PANEL_TT_HWACC = "Use GPU to speed simulation (may cause variations between simulations)",
	UI_PANEL_GROUP_VERSION = "Version",
	UI_PANEL_BT_ABOUT = "About",

	UI_PANEL_SIMULATION_TITLE = "Simulation",
	UI_PANEL_BT_RESET = "Reset",
	UI_PANEL_BT_RESET_TOOLTIP = "Reset Simulation",
	UI_PANEL_BT_PLAY = "Start",
	UI_PANEL_BT_PLAY_TOOLTIP = "Start Simulation",
	UI_PANEL_BT_PNA = "PNA",
	UI_PANEL_BT_PNA_TOOLTIP = "Start Simulation Without Animation",
	UI_PANEL_BT_STEP = "Step",
	UI_PANEL_BT_STEP_TOOLTIP = "Step Simulation",
	UI_PANEL_GROUP_SIMBAKING = "Simulation Baking",
	UI_PANEL_BT_BAKEALL = "Bake All",
	UI_PANEL_BT_BAKESEL = "Bake Selected",
	UI_PANEL_BT_UNBAKEALL = "Unbake All",
	UI_PANEL_UNBAKESEL = "Unbake Selected",
	UI_PANEL_GROUP_MODELING = "Capture Transforms",
	UI_PANEL_BT_CAPTRANS = "Capture Transform",
	UI_PANEL_UTILITY_TITLE = "Utilities",
	UI_PANEL_DESTRUCTION_TITLE = "Destruction Tools",
	UI_PANEL_DESTRUCTION_DAMAGE = "Damage",
	UI_PANEL_DESTRUCTION_RADIUS = "Radius",
	UI_PANEL_DESTRUCTION_MOMENTUM = "Momentum",
	UI_PANEL_GROUP_PHYSCENE = "Scene",
	UI_PANEL_BT_EXPLORE = "Explore Scene",
	UI_PANEL_BT_VALID = "Validate Scene",
	UI_PANEL_BT_EXPORT = "Export Scene",

	UI_PANEL_GROUP_PHYMESH = "Physical Meshes",
	UI_PANEL_IT_SHOWSEL = "Show Only for Selected",
	UI_PANEL_IT_SHOWALL = "Show All Physical Meshes",
	UI_PANEL_IT_HIDEALL = "Hide All Physical Meshes",
	UI_PANEL_TT_MESHVIS = "Show/Hide physical meshes in viewport.",
	
	UI_PANEL_VISUALIZE_ROLLOUT_RIGID_BODIES = "Rigid Bodies",
	UI_PANEL_VISUALIZE_DISPLAY_PHYSICAL_MESHES = "Display Physical Meshes",
	UI_PANEL_VISUALIZE_SELECTED_OBJECTS_ONLY = "Selected Objects Only",
	
	UI_PANEL_VISUALIZE_ROLLOUT_VISUALIZE_SUFFIX = " Visualizer", -- LOC: Suffix, appended to string "MassFX"
	UI_PANEL_VISUALIZE_ENABLE = "Enable Visualizer",
	UI_PANEL_VISUALIZE_SCALE = "Scale",
	UI_PANEL_VISUALIZE_SCALE_TOOLTIP = "Scale Factor for all Visualizer Helpers",
	
	UI_PANEL_VISUALIZE_GRP_OBJECT_PROPERTIES = "Object Properties",
	UI_PANEL_VISUALIZE_GRP_JOINT_PROPERTIES = "Joint Properties",
	UI_PANEL_VISUALIZE_GRP_CONTACT_MARKERS = "Contact Markers",
	UI_PANEL_VISUALIZE_GRP_COLLISION_MARKERS = "Collision Markers",
	
	UI_PANEL_VISUALIZE_BODY_AXES = "Local Axis",
	UI_PANEL_VISUALIZE_BODY_LIN_VELOCITY = "Object Linear Velocity",
	UI_PANEL_VISUALIZE_BODY_ANG_VELOCITY = "Object Angular Velocity",

	UI_PANEL_VISUALIZE_JOINT_LOCAL_AXES = "Local Axis",
	UI_PANEL_VISUALIZE_JOINT_WORLD_AXES = "World Axis",
	UI_PANEL_VISUALIZE_JOINT_LIMITS = "Joint Limits",

	UI_PANEL_VISUALIZE_CONTACT_POINT = "Contact Points",
	UI_PANEL_VISUALIZE_CONTACT_NORMAL = "Contact Normals",
	UI_PANEL_VISUALIZE_CONTACT_FORCE = "Contact Force",

	UI_PANEL_VISUALIZE_COLLISION_SHAPES = "Collision Meshes",
	UI_PANEL_VISUALIZE_COLLISION_COMPOUNDS = "Collision Groups",
	UI_PANEL_VISUALIZE_COLLISION_SPHERES = "Collision Spheres",
	
	/*PxExportPxProj_Prompting*/
	-----------------------------------
	UI_EXPORT_PROJECT_CAPTION = "Select File to Export",
	UI_EXPORT_PROJECT_FILETYPE = "PhysX and APEX",
	
	/*px_guiD6*/
	-----------------------------------
	UI_GUID6_D6CONN_TITLE = "Connection",
	UI_GUID6_D6CONN_UNDEF = "undefined",
	UI_GUID6_D6CONN_LB_PARENT = "Parent: ",    
	UI_GUID6_D6CONN_TT_PARENT = "Specify Parent",
	UI_GUID6_D6CONN_TT_RM_PARENT = "Remove Parent",
	UI_GUID6_D6CONN_LB_CHILD = "Child: ",
	UI_GUID6_D6CONN_TT_CHILD = "Specify Child",
	UI_GUID6_D6CONN_TT_RM_CHILD = "Remove Child",
	UI_GUID6_D6CONN_CB_BREAK = "Breakable",
	UI_GUID6_D6CONN_LB_MAXF = "Max Force",
	UI_GUID6_D6CONN_LB_MAXT = "Max Torque",
	
	UI_GUID6_TRANS_TITLE = "Translation Limits",
	UI_GUID6_TRANS_LB_LLF = "Locked   Limited  Free",
	UI_GUID6_TRANS_LB_RADIUS = "Limit Radius",
	UI_GUID6_TRANS_LB_BOUNCE = "Bounce",
	UI_GUID6_TRANS_LB_SPRING = "Spring",
	UI_GUID6_TRANS_LB_DAMP = "Damping",

	UI_GUID6_TWIST_TITLE = "Swing & Twist Limits",
	UI_GUID6_TWIST_GROUPY = "Swing Y",
	UI_GUID6_TWIST_GROUPZ = "Swing Z",
	UI_GUID6_TWIST_GROUPT = "Twist",
	
	UI_GUID6_TWIST_LB_LLF = "Locked      Limited      Free  ",
	UI_GUID6_TWIST_LB_ANGLE = "Angle Limit",
	UI_GUID6_TWIST_LB_LIMIT = "Limit",
	UI_GUID6_TWIST_LB_LR = "Left          Right     ",

	UI_GUID6_SPRING_TITLE = "Spring",
	UI_GUID6_SPRING_GROUPP = "Spring to Resting Position",
	UI_GUID6_SPRING_GROUPS = "Spring to Resting Swing",
	UI_GUID6_SPRING_GROUPT = "Spring to Resting Twist",
	UI_GUID6_SPRING_LB_SPRGNS = "Springiness",
	
	UI_GUID6_ADV_TITLE = "Advanced",
	
	UI_GUID6_ADV_BTN_TOPARENT = "Move to Parent's Pivot",
	UI_GUID6_ADV_BTN_TOCHILD = "Move to Child's Pivot",
	
	UI_GUID6_ADV_LB_DISPSIZE = "Display Size",
	UI_GUID6_ADV_CB_COLLISION = "Parent/Child Collision",
	UI_GUID6_ADV_CB_GEARING = "Parent Turns Child",
	UI_GUID6_ADV_LB_GEARRATIO = "Gear Ratio",
	UI_GUID6_ADV_CB_USEPROJ = "Use Projection",
	UI_GUID6_ADV_RB_LB1 = "Linear Only (faster)  ",
	UI_GUID6_ADV_RB_LB2 = "Linear and Angular  ",
	UI_GUID6_ADV_LB_DIST = "Distance",
	UI_GUID6_ADV_LB_ANGLE = "Angle",	

	
	/*px_guiMenuToolbar*/
	-----------------------------------
	UI_GUIMT_EXPORT_TITLE = "PhysX Export",
	UI_GUIMT_EXPORT_LB_INFO = "Exporting PhysX Scene",
	UI_GUIMT_EXPORT_CB_VALIDATE = "Validate scene before export",
	UI_GUIMT_EXPORT_BT_EXP = "Export to new file",
	UI_GUIMT_EXPORT_BT_QUICKEXP = "Export to last file/type"

)

nvpxText = nvpxText()
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCfOR8dvtJHeiHMPZmNsmWoeuHQ3J7Q5mmy
-- vVXkj8E7U5/rkTTzN03eeQReSqBOucFxBC33ePUV2916yokzxPccI7JRkV0CBI8o
-- +FnrnDxsMVG9+IloDGhrm6lJCtDb3r2C7SciSYocxeT5JkAKq88zplw6d4qzzWu0
-- lmjmHuSDtObLpWk2qEd5AdGojkCM2SRibBa+6M7B6NapkBy3lNwY1bQgldZR8fdj
-- TCR8y5nWHRtc3frTsT/gcsBdJJ5YnkmNdXFlLxxHBaZi2SWgKTvMY167pVi3xtJn
-- NBX4x7Z8JGdSngjz2iou6rGmhaF3kXsJiC1+HhnzMIO3e/1RJEx2
-- -----END-SIGNATURE-----